/* Copyright (C) 1999 Lucent Technologies */
/* Kod z ksiki The Practice of Programming */
/* Briana W. Kernighana i Roba Pike'a */

#include <time.h>
#include <iostream>
#include <string>
#include <deque>
#include <map>
#include <vector>

using namespace std;

const int  NPREF = 2;
const char NONWORD[] = "\n";	/* Nie moe wystpi jako zwyke sowo */
const int  MAXGEN = 10000; // Limit liczby sw, jak mona wygenerowa

typedef deque<string> Prefix;

map<Prefix, vector<string> > statetab; // przedrostek -> przyrostki

void		build(Prefix&, istream&);
void		generate(int nwords);
void		add(Prefix&, const string&);

// main: funkcja generujca tekst przy uyciu algorytmu acucha Markowa
int main(void)
{
	int	nwords = MAXGEN;
	Prefix prefix;	// Biecy przedrostek wejciowy

	srand(time(NULL));
	for (int i = 0; i < NPREF; i++)
		add(prefix, NONWORD);
	build(prefix, cin);
	add(prefix, NONWORD);
	generate(nwords);
	return 0;
}

// build: pobiera sowa z wejcia i tworzy tablic stanw
void build(Prefix& prefix, istream& in)
{
	string buf;

	while (in >> buf)
		add(prefix, buf);
}

/// add: dodaje sowo do listy przyrostkw, aktualizuje przedrostek
void add(Prefix& prefix, const string& s)
{
	if (prefix.size() == NPREF) {
		statetab[prefix].push_back(s);
		prefix.pop_front();
	}
	prefix.push_back(s);
}

// generate: tworzy dane wyjciowe, po jednym sowie na wiersz
void generate(int nwords)
{
	Prefix prefix;
	int i;

	for (i = 0; i < NPREF; i++)
		add(prefix, NONWORD);
	for (i = 0; i < nwords; i++) {
		vector<string>& suf = statetab[prefix];
		const string& w = suf[rand() % suf.size()];
		if (w == NONWORD)
			break;
		cout << w << "\n";
		prefix.pop_front();	// Przesunicie
		prefix.push_back(w);
	}
}
